import * as config from './config';
import * as Unit from './entity/Unit';
import * as units from './entity/units';
import * as Player from './entity/Player';
import * as Projectile from './entity/Projectile';
import * as Type from './entity/Type';
import * as Pickup from './entity/Pickup';
import * as rangedAction from './entity/units/actions/rangedAction';
import * as meleeAction from './entity/units/actions/meleeAction';
import * as Angle from './jmath/Angle';
import * as ArrayUtil from './jmath/ArrayUtil';
import * as Easing from './jmath/Easing';
import * as lineSegment from './jmath/lineSegment';
import * as math from './jmath/math';
import * as moveWithCollision from './jmath/moveWithCollision';
import * as Pathfinding from './jmath/Pathfinding';
import * as Polygon2 from './jmath/Polygon2';
import * as rand from './jmath/rand';
import * as Rect from './jmath/Rect';
import * as Vec from './jmath/Vec';
import { MultiColorReplaceFilter } from '@pixi/filter-multi-color-replace';
import * as AnimationCombos from './graphics/AnimationCombos';
import * as FloatingText from './graphics/FloatingText';
import * as JImage from './graphics/Image';
import * as ImmediateModeSprites from './graphics/ImmediateModeSprites';
import * as JpromptAll from './graphics/Jprompt';
import * as ParticleCollection from './graphics/ParticleCollection';
import * as Particles from './graphics/Particles';
import * as PixiUtils from './graphics/PixiUtils';
import * as PlanningView from './graphics/PlanningView';
import * as CardUI from './graphics/ui/CardUI';
import * as colors from './graphics/ui/colors';
import * as colorUtil from './graphics/ui/colorUtil';
import * as eventListeners from './graphics/ui/eventListeners';
import * as keyMapping from './graphics/ui/keyMapping';
import * as JAudio from './Audio';
import * as VisualEffects from './VisualEffects';
import * as inLiquid from './inLiquid';
import * as LiquidPools from './LiquidPools';
import * as modifierSummonerSickness from './modifierSummoningSickness';
import * as Overworld from './Overworld';
import * as Perk from './Perk';
import * as PlayerUtils from './PlayerUtils';
import * as JPromise from './Promise';
import * as storage from './storage';
import * as Subsprites from './Subsprites';
import * as Underworld from './Underworld';
import * as cardUtils from './cards/cardUtils';
import * as cards from './cards/index';
import * as cardsUtil from './cards/util';
import * as Events from './Events';
import { forcePushTowards, forcePushAwayFrom, forcePushToDestination, forcePushDelta } from './effects/force_move';
import * as commonTypes from './types/commonTypes';
import * as particleEmitter from '@pixi/particle-emitter';
declare const SpellmasonsAPI: {
    Angle: typeof Angle;
    AnimationCombos: typeof AnimationCombos;
    ArrayUtil: typeof ArrayUtil;
    cards: typeof cards;
    cardsUtil: typeof cardsUtil;
    CardUI: typeof CardUI;
    cardUtils: typeof cardUtils;
    colors: typeof colors;
    colorUtil: typeof colorUtil;
    commonTypes: typeof commonTypes;
    config: typeof config;
    Easing: typeof Easing;
    eventListeners: typeof eventListeners;
    Events: typeof Events;
    FloatingText: typeof FloatingText;
    forcePushDelta: typeof forcePushDelta;
    forcePushTowards: typeof forcePushTowards;
    forcePushAwayFrom: typeof forcePushAwayFrom;
    forcePushToDestination: typeof forcePushToDestination;
    ImmediateModeSprites: typeof ImmediateModeSprites;
    inLiquid: typeof inLiquid;
    JAudio: typeof JAudio;
    JImage: typeof JImage;
    JPromise: typeof JPromise;
    JpromptAll: typeof JpromptAll;
    keyMapping: typeof keyMapping;
    lineSegment: typeof lineSegment;
    LiquidPools: typeof LiquidPools;
    math: typeof math;
    meleeAction: typeof meleeAction;
    modifierSummonerSickness: typeof modifierSummonerSickness;
    moveWithCollision: typeof moveWithCollision;
    MultiColorReplaceFilter: typeof MultiColorReplaceFilter;
    Overworld: typeof Overworld;
    ParticleCollection: typeof ParticleCollection;
    particleEmitter: typeof particleEmitter;
    Particles: typeof Particles;
    Pathfinding: typeof Pathfinding;
    Perk: typeof Perk;
    Pickup: typeof Pickup;
    PixiUtils: typeof PixiUtils;
    PlanningView: typeof PlanningView;
    Player: typeof Player;
    PlayerUtils: typeof PlayerUtils;
    Polygon2: typeof Polygon2;
    Projectile: typeof Projectile;
    rand: typeof rand;
    rangedAction: typeof rangedAction;
    Rect: typeof Rect;
    storage: typeof storage;
    Subsprites: typeof Subsprites;
    Type: typeof Type;
    Underworld: typeof Underworld;
    Unit: typeof Unit;
    units: typeof units;
    Vec: typeof Vec;
    VisualEffects: typeof VisualEffects;
};
export default SpellmasonsAPI;
