import * as particles from '@pixi/particle-emitter';
import { Vec2 } from '../jmath/Vec';
import { IUnit } from '../entity/Unit';
import Underworld from '../Underworld';
import { IPickup } from '../entity/Pickup';
export declare function makeAncientParticles(position: Vec2, prediction: boolean): void;
export declare function makeParticleExplosion(position: Vec2, size: number, colorStart: number, colorEnd: number, prediction: boolean): void;
export declare function makeBloatExplosionWithParticles(position: Vec2, size: number, prediction: boolean): void;
export declare function makeAlchemizeParticles(potion: IPickup, prediction: boolean, resolver?: () => void): void;
export declare function makeBleedParticles(position: Vec2, prediction: boolean, proportion: number, resolver?: () => void): void;
export declare function makeRisingParticles(position: Vec2, prediction: boolean, color?: string, emitterLifetime?: number): import("../types/commonTypes").JEmitter | undefined;
export declare function makeBurstParticles(position: Vec2, finalScale: number, prediction: boolean, resolver?: () => void): void;
export declare function makeScrollDissapearParticles(position: Vec2, prediction: boolean): void;
export declare function makeDarkPriestAttackParticles(position: Vec2, prediction: boolean, resolver?: () => void): void;
export declare function makeCorruptionParticles(follow: IUnit, prediction: boolean, underworld: Underworld, resolver?: () => void): void;
export declare function makeCursedEmitter(position: Vec2, prediction: boolean): import("../types/commonTypes").JEmitter | undefined;
export declare const RED_PORTAL_JID = "redPortal";
export declare const BLUE_PORTAL_JID = "bluePortal";
export declare function makeDeathmasonPortal(position: Vec2, prediction: boolean, colorStart: string, colorEnd: string): import("../types/commonTypes").JEmitter | undefined;
export declare function makeLightBeamParticles(position: Vec2): void;
export declare function makePrimedCorpseParticles(follow: IUnit, underworld: Underworld, prediction: boolean, resolver?: () => void): void;
export declare function stopAndDestroyForeverEmitter(emitter?: particles.Emitter): void;
