//
// "bodselect.js" - Change form elements based on the user's BOD selection
//

function updateFields(change_selection)
{
	var bod_id = document.getElementById("item").value;

	limitTypes(bod_id, change_selection);
	limitMaterials(bod_id, change_selection);
}

// The functions below could use some improvement...
// This is the "easy" way. :)

function limitTypes(bod_id, change_selection)
{
	document.getElementById("type_all").disabled = !(bod_id == -1);
	document.getElementById("type_small").disabled = !((bod_id == -1) || (bod_id >= 1000 && bod_id < 1100) || (bod_id >= 2000 && bod_id < 2100));
	document.getElementById("type_large").disabled = !((bod_id == -1) || (bod_id >= 1100 && bod_id < 2000) || (bod_id >= 2100 && bod_id < 3000));
	
	if(!change_selection)
		return;
	
	// Reverse order
	document.getElementById("type_large").checked = !document.getElementById("type_large").disabled;
	document.getElementById("type_small").checked = !document.getElementById("type_small").disabled;
	document.getElementById("type_all").checked = !document.getElementById("type_all").disabled;
}

function limitMaterials(bod_id, change_selection)
{
	document.getElementById("skill_any").disabled = !(bod_id == -1);
	
	if((bod_id == -1) || (bod_id >= 1000 && bod_id < 2000))
	{
		document.getElementById("skill_1").disabled = false;
		
		document.getElementById("mat_1000").disabled = !((bod_id == -1) || (bod_id >= 1000 && bod_id < 1029) || (bod_id >= 1100 && bod_id < 1105) || (bod_id >= 1106 && bod_id < 1111));
		for(var i = 1001; i <= 1004; i++)
			document.getElementById("mat_" + i).disabled = !((bod_id == -1) || (bod_id >= 1029 && bod_id < 1100) || (bod_id == 1105) || (bod_id >= 1111 && bod_id < 2000));
	}
	else
	{
		document.getElementById("skill_1").disabled = true;
		
		for(var i = 1000; i <= 1004; i++)
			document.getElementById("mat_" + i).disabled = true;
	}
	
	if((bod_id == -1) || (bod_id >= 2000 && bod_id < 3000))
	{
		document.getElementById("skill_2").disabled = false;
		
		document.getElementById("mat_2000").disabled = false;
		for(var i = 2001; i <= 2008; i++)
			document.getElementById("mat_" + i).disabled = !((bod_id == -1) || (bod_id >= 2000 && bod_id < 2024) || (bod_id >= 2100 && bod_id < 2103));
	}
	else
	{
		document.getElementById("skill_2").disabled = true;
		
		for(var i = 2000; i <= 2008; i++)
			document.getElementById("mat_" + i).disabled = true;
	}
	
	if(!change_selection)
		return;
	
	// Reverse order
	document.getElementById("skill_2").checked = !document.getElementById("skill_2").disabled;
	document.getElementById("skill_1").checked = !document.getElementById("skill_1").disabled;
	document.getElementById("skill_any").checked = !document.getElementById("skill_any").disabled;
}